unit IWCompText;
{PUBDIST}

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.Drawing, IWNetClasses,
  {$ELSE}
    Classes,
    {$IFDEF Linux}
    IWCLXComponent, IWCLXClasses,
    {$ELSE}
    IWVCLComponent, IWVCLClasses,
    {$ENDIF}
    {$IFDEF Linux}QControls,{$ELSE}Controls,{$ENDIF}
  {$ENDIF}
  IWControl, IWHTMLTag, IWRenderContext, IWGlobal, IWColor, IWBaseInterfaces;

type
  TIWCustomText = class(TIWCustomControl)
  protected
    FBGColor: TIWColor;
    FConvertSpaces: Boolean;
    FLines: TIWStringList;
    FRawText: boolean;
    FWantReturns: boolean;
    //
    procedure OnItemsChange(ASender : TObject);
    procedure SetLines(const AValue: TIWStringList);
    procedure SetBGColor(const AValue : TIWColor);

    procedure InitControl; override;

    property ConvertSpaces: Boolean read FConvertSpaces write FConvertSpaces;

    property RawText: boolean read FRawText write FRawText;

    property WantReturns: Boolean read FWantReturns write FWantReturns;
  {$IFDEF CLR}
  strict protected
  {$ELSE}
  protected
  {$ENDIF}
    {$IFNDEF CLR}
    function getText: TCaption; override;
    procedure TextChangedNotification; override;
    {$ENDIF}
    procedure Dispose(ADispose: Boolean); override;
  protected
    function get_HasTabOrder: boolean;override;
  public
    {$IFNDEF CLR}
    procedure setText(const AValue: TCaption); override;
    {$ENDIF}
    procedure Clear; virtual;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
    function RenderStyle(AContext: TIWBaseHTMLComponentContext): string; override;

    property BGColor: TIWColor read FBGColor write SetBGColor;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Lines: TIWStringList read FLines write SetLines;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWText.bmp}
  TIWText = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWText), 'TIWText.bmp')]
  {$ENDIF}
  TIWText = class(TIWCustomText)
  published
    property BGColor;
    property ConvertSpaces;
    {$IFDEF CLR}
    property WebFont;
    {$ELSE}
    property Font;
    {$ENDIF}
    property FriendlyName;
    {$IFDEF VSNET}
    [Bindable(true)]
    {$ENDIF}
    property Lines;
    property RawText;
    property UseFrame;
    property WantReturns;
  end;

implementation

uses
  {$IFDEF Linux}QGraphics,{$ELSE}Graphics,{$ENDIF}
  SysUtils,
  IWServerControllerBase,
  SWSystem;

procedure TIWCustomText.InitControl;
begin
  inherited;
  BGColor := fromTColor(clNone);
  Height := 121;
  Width := 121;
  FLines := TIWStringList.Create;
  FLines.OnChange := OnItemsChange;
  FWantReturns := True;
  FConvertSpaces := False;
end;

procedure TIWCustomText.OnItemsChange( ASender : TObject );
begin
  DoRefreshControl := True;
  Invalidate;
end;

procedure TIWCustomText.Dispose(ADispose: Boolean);
begin
  FreeAndNil(FLines);
  inherited;
end;

procedure TIWCustomText.SetLines(const AValue: TIWStringList);
begin
  FLines.Assign(AValue);
  Text := FLines.Text;
  Invalidate;
end;

procedure TIWCustomText.SetBGColor(const AValue : TIWColor);
begin
  if AValue <> FBGColor then
  begin
    FBGColor := AValue;
    Invalidate;
  end;
end;

function TIWCustomText.get_HasTabOrder: boolean;
begin
  Result := false;
end;

{ TIWHTMLText }

function TIWCustomText.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  s : string;
  f : integer;
begin
  s := FLines.Text;
  if not RawText then
  begin
    s := TextToHTML(s, WantReturns, ConvertSpaces);
  end
  else
  begin // RawText = TRUE
    if WantReturns then
    begin
      // RawText and WantReturns = TRUE
      // For every item in Lines property a CRLF is added
      s := '';
      for f := 0 to Pred(FLines.Count) do
        s := s + FLines.Strings[f] + CR + LF;
    end
    else
    begin
      // RawText = TRUE and WantReturns = FALSE
      // Items in Lines propery are just concatenated.
      s := '';
      for f := 0 to Pred(FLines.Count) do
        s := s + FLines.Strings[f];
    end;
  end;

  Result := TIWHTMLTag.CreateTag('DIV');
  try
    Result.Contents.AddText(s);
  except
    FreeAndNil(Result);
    raise;
  end;
end;

procedure TIWCustomText.Clear;
begin
  Lines.Clear;
end;

function TIWCustomText.RenderStyle(AContext: TIWBaseHTMLComponentContext): string;
begin
  Result := inherited RenderStyle(AContext);
  if toTColor(BGColor) <> clNone then begin
    Result := Result + ' background-color: ' + ColorToRGBString(BGColor)+ ';';
  end;
end;

{$IFNDEF CLR}

procedure TIWCustomText.TextChangedNotification;
begin
  FLines.Text := Text;
end;

procedure TIWCustomText.setText(const AValue: TCaption);
begin
  FLines.Text := AValue;
end;

function TIWCustomText.getText: TCaption;
begin
  Result := FLines.Text;
end;
{$ENDIF}

end.

